import net.BurtonRadons.dig.main;

class ThemeExplorer : Frame
{
    import net.BurtonRadons.dig.platform.windows;
    import net.BurtonRadons.dig.platform.windowsTheme;
	private import std.c.windows.windows;
	
    Canvas preview;
    ComboBox control;
    ComboBox part;
    ComboBox state;

    char [] controlName;
    int partIndex;
    int stateIndex;
    ListBox list;

    HTHEME [char []] themes;

    alias WindowsTheme w;

    HTHEME getTheme ()
    {
        if (controlName in themes)
            return themes [controlName];
        return themes [controlName] = w.OpenThemeData (preview.digPlatformHWND, toWStringz (controlName));
    }

    class PropRow : ListBox.Row
    {
        HTHEME theme;
        _HDC hdc;
        int part;
        int state;
        int prop;
        char [] type;
        char [] name;

        this (HTHEME theme, _HDC hdc, int part, int state, int prop, char [] type, char [] name)
        {
            this.theme = theme;
            this.hdc = hdc;
            this.part = part;
            this.state = state;
            this.prop = prop;
            this.type = type;
            this.name = name;
        }

        override int compare (ListBox.Row other, ListBox.Column column)
        {
            int i = column.orderedIndex ();

            if (cast (PropRow) other)
                return std.string.cmp (name, (cast (PropRow) other).name);
            assert (0);
        }

        override void display (int x, int y, bit selected, bit focus, bit enabled)
        {
            for (int c; c < control.orderedColumnCount (); c ++)
            {
                ListBox.Column column = control.orderedColumn (c);
                int bx = x + column.offsetx ();
                int width = column.width;

                if (column.columnIndex () == 0)
                    control.textPrintEllipses (bx, y, width, 0, name);
                else
                {
                    if (type === null)
                        continue;
                    else if (type == "BOOL")
                    {
                        _BOOL value;

                        w.GetThemeBool (theme, part, state, prop, &value);
                        control.textPrintEllipses (bx, y, width, 0, value ? (char []) "TRUE" : (char []) "FALSE");
                    }
                    else if (type == "INT")
                    {
                        int value;

                        w.GetThemeInt (theme, part, state, prop, &value);
                        control.textPrintEllipses (bx, y, width, 0, fmt ("%d", value));
                    }
                    else if (type == "FILENAME")
                    {
                        wchar [1024] value;

                        w.GetThemeFilename (theme, part, state, prop, value, value.length);
                        control.textPrintEllipses (bx, y, width, 0, fmt ("\"%S\"", (wchar *) value));
                    }
                    else if (type == "ENUM")
                    {
                        int value;

                        w.GetThemeEnumValue (theme, part, state, prop, &value);
                        control.textPrintEllipses (bx, y, width, 0, fmt ("%.*s", w.propertyEnumValueName (prop, value)));
                    }
                    else if (type == "COLOR")
                    {
                        _COLORREF ref;
                        Color color;
                        int ex = imin (control.visualWidth (), bx + width);

                        w.GetThemeColor (theme, part, state, prop, &ref);
                        color = AColor (ref & 0xFF, (ref >> 8) & 0xFF, (ref >> 16) & 0xFF);

                        control.penWidth (1);
                        control.penStyle ("---");
                        control.penColor (Color.Black);
                        control.brushColor (color);
                        control.rect (bx, y, ex, y + control.textHeight ());
                    }
                    else if (type == "MARGINS")
                    {
                        MARGINS margins;
                        _RECT rect;

                        rect.left = rect.top = 0;
                        rect.right = rect.bottom = 100;
                        w.GetThemeMargins (theme, hdc, part, state, prop, &rect, &margins);
                        control.textPrintEllipses (bx, y, width, 0, fmt ("%.*s", margins.toString ()));
                    }
                    else
                        throw new Error (type);
                }
            }
        }

        override int height ()
        {
            return control.textHeight ();
        }
    }

    this ()
    {
        caption ("List test");
        border (0, 0);
        suggestWidthAndHeight (200, 400);

        with (list = new ListBox (this))
        {
            grid (0, 0, 1, 4);
            pad (0, 0);
            sticky ("^v");

            addColumn ("Name", 200);
            addColumn ("Value", 100);
        }

        char [] [] list = w.controlNames;

        with (control = new ComboBox (this))
        {
            grid (1, 0);
            for (int c; c < list.length; c ++)
                add (list [c], list [c]);
            onChange.add (&changeControl);
            sticky ("<>");
        }

        with (part = new ComboBox (this))
        {
            grid (1, 1);
            onChange.add (&changePart);
            sticky ("<>");
        }

        with (state = new ComboBox (this))
        {
            grid (1, 2);
            onChange.add (&changeState);
            sticky ("<>");
        }

        with (preview = new Canvas (this))
        {
            grid (1, 3);
            onPaint.add (&previewPaint);
            suggestWidthAndHeight (200, 200);
            sticky ("<>^v");
        }
    }

    void previewPaint ()
    {
        HTHEME theme;
        _RECT rect;
        
        _RECT *set (float sx, float sy, float ex, float ey)
        {
            rect.left = sx * preview.width ();
            rect.top = sy * preview.height ();
            rect.right = ex * preview.width ();
            rect.bottom = ey * preview.height ();
            return &rect;
        }
        
        preview.beginPaint ();
        preview.clear (AColor (128, 164, 128));

        if (!w.available)
            preview.textPrint (0, 0, "Themes not available");
        else if (controlName !== null && (theme = getTheme ()) !== null)
        {
            w.DrawThemeBackground (theme, preview.digPlatformHDC, partIndex, stateIndex, set (0, 0, 0.5, 0.5), null);
            w.DrawThemeText (theme, preview.digPlatformHDC, partIndex, stateIndex, "Text", 4, 0, 0, set (0.5, 0, 1, 0.5));
            //w.DrawThemeParentBackground (theme, preview.hdc, partIndex, stateIndex, set (0, 0.5, 0.5, 1));
            w.DrawThemeEdge (theme, preview.digPlatformHDC, partIndex, stateIndex, set (0, 0.5, 0.5, 1),
                EDGE_BUMP,
                BF_RECT,
                null);
        }

        preview.endPaint ();
    }

    void changeControl (Event e)
    {
        controlName = e.keyCode;

        char [] [] list = w.controlPartNames (controlName);

        part.empty ();
        state.empty ();
        for (int c; c < list.length; c ++)
            part.add (list [c], list [c]);
        e.keyCode = list [0];
        part.current (list [0]);
        part.makeFocus ();
        changePart (e);
    }

    void changePart (Event e)
    {
        char [] name = e.keyCode;

        char [] [] list = w.controlPartNames (controlName);
        int [] values = w.controlParts (controlName);
        char [] first;

        stateIndex = 0;

        for (int c; ; c ++)
        {
            if (name != list [c])
                continue;

            partIndex = values [c];
            list = w.controlPartStateNames (controlName, values [c]);
            state.empty ();
            for (int c; c < list.length; c ++)
                state.add (list [c], list [c]);

            stateIndex = 0;
            preview.paint ();
            setList ();

            state.enabled (list.length != 0);
            state.makeFocus ();
            if (list.length)
                state.current (list [0]);
            break;
        }
    }

    void changeState (Event e)
    {
        char [] name = e.keyCode;
        char [] [] nlist = w.controlPartStateNames (controlName, partIndex);
        int [] values = w.controlPartStates (controlName, partIndex);

        for (int c; ; c ++)
        {
            if (name != nlist [c])
                continue;

            stateIndex = values [c];
            preview.paint ();
            break;
        }

        setList ();
    }

    void setList ()
    {
        list.empty ();
        if (!w.available)
            return;

        HTHEME theme = getTheme ();

        if (theme == (_HANDLE) 0)
            return;

        int [] props = w.themeAvailableProperties (theme, preview.digPlatformHDC, partIndex, stateIndex);

        for (int c; c < props.length; c ++)
        {
            char [] type = w.propertyValue (props [c], "type");
            char [] name = w.propertyValue (props [c], "name");

            list.add (new PropRow (theme, preview.digPlatformHDC, partIndex, stateIndex, props [c], type, name));
        }

        list.paint ();
    }
}

void main ()
{
    (new ThemeExplorer).showModal ();
}
